const express = require('express');
const dotenv = require('dotenv');
const cors = require('cors');
const connectDB = require('./config/db');

// Load environment variables
dotenv.config();

// Connect to database
connectDB();

const app = express();

// --- Middleware ---
// Enable CORS for client access
app.use(cors({ origin: ['http://localhost:5174', 'https://miragem.whirelab.com/', 'https://app-miragem.whirelab.com/', 'http://localhost:5173'] })); // Replace 3000 with your actual client port
// Body parser (to accept JSON data)
app.use(express.json()); 

// --- Routes ---
const waitlistRoutes = require('./routes/waitlistRoutes');
const quizRoutes = require('./routes/quizRoutes');
const adminRoutes = require('./routes/adminRoutes');

// Public routes
app.use('/api/waitlist', waitlistRoutes);
app.use('/api/quiz', quizRoutes);

// Admin and Protected Routes
app.use('/api/admin', adminRoutes);

// Simple test route
app.get('/', (req, res) => {
    res.send('Miragem API is running... 🌙');
});

// --- Server Startup ---
const PORT = process.env.PORT || 5001;

app.listen(
    PORT, 
    console.log(`Server running in ${process.env.NODE_ENV || 'development'} mode on port ${PORT}`)
);