const jwt = require('jsonwebtoken');

// Middleware to protect routes
const protect = (req, res, next) => {
    let token;

    // Check for token in headers (Bearer Token)
    if (req.headers.authorization && req.headers.authorization.startsWith('Bearer')) {
        try {
            // Get token from header (format: Bearer <token>)
            token = req.headers.authorization.split(' ')[1];

            // Verify token
            const decoded = jwt.verify(token, process.env.JWT_SECRET);

            // Attach the user ID to the request object (assuming JWT contains { id: userId })
            req.userId = decoded.id; 
            
            next();
        } catch (error) {
            console.error(error);
            res.status(401).json({ message: 'Not authorized, token failed' });
        }
    }

    if (!token) {
        res.status(401).json({ message: 'Not authorized, no token' });
    }
};

// Middleware to check if user is an admin (optional, assuming all authenticated users are admins for simplicity)
const admin = (req, res, next) => {
    // For a simple setup, we just check if they are authenticated. 
    // In a real app, you would check the database for req.userId's role.
    next();
};

module.exports = { protect, admin };